package gov.va.vinci.dart.dms.db.impl;

import java.util.List;

import javax.persistence.Query;

import gov.va.vinci.dart.db.util.HibernateDAO;
import gov.va.vinci.dart.dms.biz.Label;
import gov.va.vinci.dart.dms.db.LabelDAO;

public class LabelDAOImpl extends HibernateDAO implements LabelDAO {

	@Override
	public Label findById(final int labelId) {
		Query q = createQuery("from Label where id=:lid");
		q.setParameter("lid", labelId);
		return (Label)q.getSingleResult();
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Label> listByDocumentId(final int documentId) {
		Query q = createQuery("from Label where document.id=:did");
		q.setParameter("did", documentId);
		return (List<Label>)q.getResultList();
	}

	@Override
	public void save(Label label) {
		if (label == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(label);
	}

	@Override
	public void delete(Label label) {
		if (label == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.delete(label);
	}

	@Override
	public void deleteAllCurrentLabels(int documentId) {
		Query q = createNativeQuery("delete from hib.label where documentid in (select id from hib.document where id=:did or head=:did) and value like 'CURRENT'");
		q.setParameter("did", documentId);
		q.executeUpdate();
	}

}
